/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ReduceToolDamageModule;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class IgneousModifier
extends Modifier
implements ModifierRemovalHook,
TooltipModifierHook,
ToolDamageModifierHook,
MeleeDamageModifierHook,
BreakSpeedModifierHook,
InventoryTickModifierHook,
ConditionalStatModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "igneous_mod");
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"igneous.unbreaking");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.INVENTORY_TICK, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.TOOLTIP, ModifierHooks.TOOL_DAMAGE});
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.KEY, 5)) {
            float value = persistentData.getFloat(this.KEY);
            return (float)((double)damage * (1.0 + (double)value * 0.1));
        }
        return damage;
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.KEY, 5)) {
            float value = persistentData.getFloat(this.KEY);
            event.setNewSpeed((float)((double)event.getOriginalSpeed() * (1.0 + (double)value * 0.1)));
        }
    }

    public int getPriority() {
        return 120;
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @javax.annotation.Nullable LivingEntity holder) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.KEY, 5)) {
            float value = persistentData.getFloat(this.KEY);
            if (value >= (float)modifier.getLevel() / 5.0f) {
                return ReduceToolDamageModule.reduceDamage((int)amount, (float)((float)(0.1 * (double)modifier.getLevel())));
            }
            return ReduceToolDamageModule.reduceDamage((int)amount, (float)(value / 10.0f));
        }
        return amount;
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        if (tool.getModifierLevel(this.getId()) == 0) {
            tool.getPersistentData().remove(this.KEY);
        }
        return null;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.KEY, 5)) {
            float value = persistentData.getFloat(this.KEY);
            if (stat == ToolStats.DRAW_SPEED) {
                return (float)((double)baseValue * (1.0 + (double)value * 0.1));
            }
            if (stat == ToolStats.PROJECTILE_DAMAGE) {
                return (float)((double)baseValue * (1.0 + (double)value * 0.1));
            }
        }
        return baseValue;
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!world.f_46443_ && holder.f_19797_ % 100 == 0 && isSelected && holder.m_6060_() && persistentData.getFloat(this.KEY) <= (float)(5 * modifier.getLevel()) && RANDOM.nextFloat() <= 0.6f * (float)modifier.getLevel()) {
            persistentData.putFloat(this.KEY, persistentData.getFloat(this.KEY) + 0.1f);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null) {
            ModDataNBT persistentData = tool.getPersistentData();
            boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
            if (persistentData.contains(this.KEY, 5)) {
                float value = persistentData.getFloat(this.KEY);
                TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.modifier.igneous.attack_damage"), (double)((double)value * 0.1), tooltip);
                if (harvest) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.modifier.igneous.mining_speed"), (double)((double)value * 0.1), tooltip);
                } else {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.modifier.igneous.draw_speed"), (double)((double)value * 0.1), tooltip);
                }
                if (value >= (float)modifier.getLevel()) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)UNBREAKING, (double)(0.1 * (double)modifier.getLevel()), tooltip);
                } else if (value < (float)modifier.getLevel()) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)UNBREAKING, (double)(value / 10.0f), tooltip);
                }
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.igneous.cap").m_130940_(ChatFormatting.DARK_PURPLE));
            }
        }
    }
}

